/**
 * 
 */
package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.transfer.QueryRequest;

import java.util.Map;

/**
 * @author DNS
 *
 */
public class PojoPhrServiceLocator<T extends PhrService, N extends QueryRequest> implements ServiceLocator<T,N> {
	
	protected Map<String, T> serviceMap; 
	
	@Override
	public T locateService(N serviceQualifier)
			throws ServiceLocatorException {
	
		if(this.serviceMap == null)
		{
			throw new ServiceLocatorException("Unitialized service locator exception.");
		}
		
		T service = getService(getServiceId(serviceQualifier.getIcn(), serviceQualifier.getExtractType())); 
		
		if(service == null)
		{
			throw new ServiceLocatorException(String.format("Service unavailable exception. Service name: %s", serviceQualifier));
		}
		
		return service;
	}
	
	@Override
	public String getServiceId(String userid, String serviceType)
			throws ServiceLocatorException {
		return serviceType;
	}
	
	protected T getService(String serviceId)
	{
		return this.serviceMap.get(serviceId);
	}
	
	/**
	 * 
	 * @param serviceMap
	 */
	public void setServiceMap(Map<String, T> serviceMap) {
		this.serviceMap = serviceMap;
	}

}
